# Streamlit 登录系统说明手册



### 项目文件结构

```python
streamlit_login/
├── main_app.py # 项目主程序
├── init_db.py # 初始化数据库
├── subpages/ # 子页面
│   ├── __init__.py # 初始化文件
│   ├── home.py # 我的主页
│   ├── data_analysis.py # 数据分析页面
│   └── about.py # 关于页面
├── lottie/ # 页面动画
│   ├── login.json
│   └── register.json
```

---



### Python 环境准备

#### Python 版本

```python
Python == 3.12.3
```

---

#### Python 依赖库

```python
# (Step01) 使用 miniconda 管理环境
conda create -n streamlit-login python=3.12.3
conda activate streamlit-login

# (Step02) 安装 requirements.txt 中的依赖，不使用缓存(--no-cache-dir)
pip install --no-cache-dir -i https://mirrors.bfsu.edu.cn/pypi/web/simple streamlit==1.45.1 streamlit-lottie==0.0.5 streamlit-option-menu==0.4.0 pandas==2.3.0 numpy==2.3.0 matplotlib==3.10.3
```

---



### 数据库初始化

```python
conda activate streamlit-login
cd ./streamlit_login
python init_db.py
```

---



### 启动主服务

```python
conda activate streamlit-login
cd ./streamlit_login
# 指定端口号
streamlit run main_app.py --server.port 9080
```

---



