import streamlit as st

def show():
    # 气球特效
    st.balloons()
    st.markdown("### 🎉 您已成功登录系统！以下是您的主页内容。")
    st.info("📌 当前为默认主页模块，可在左侧菜单中切换其他功能。")
    
    col1, col2, col3 = st.columns(3)
    with col1:
        st.metric("今日访问量", "128", "+12%")
    with col2:
        st.metric("注册用户", "56", "+5")
    with col3:
        st.metric("系统状态", "运行中", "正常")

    st.divider()
    st.write("### 📋 系统功能概览")
    st.write("- 用户认证与权限管理")
    st.write("- 数据可视化分析")
    st.write("- 系统配置与个性化设置")
    st.write("- 多页面导航与状态管理")