import streamlit as st


def show():
    # 页面标题与欢迎语
    st.markdown("### 💡 关于本平台")

    # 平台简介
    st.markdown("""
    欢迎来到 **智析 - 智能数据分析平台**！  
    这是一个基于 Python 构建的现代化数据可视化与分析工具，旨在帮助用户快速洞察数据价值。  
    我们专注于：

    - 🔍 数据探索与清洗
    - 📊 多维度可视化分析
    - 🛡️ 安全的用户权限管理
    - 📱 响应式界面，支持多种设备访问
    """)

    st.divider()

    # 技术栈介绍
    st.markdown("#### 🛠️ 使用的技术")
    col1, col2, col3 = st.columns(3)

    with col1:
        st.info("""
        **核心框架**

        - Streamlit（前端交互）
        - SQLite / Pandas（数据处理）
        """)
    with col2:
        st.info("""
        **数据可视化**

        - Matplotlib
        - Seaborn
        - Plotly（交互图表）
        """)
    with col3:
        st.info("""
        **UI/UX 组件**

        - Streamlit-Lottie（动画效果）
        - Streamlit-Option-Menu（导航菜单）
        - 自定义 CSS 美化
        """)

    st.divider()

    # 联系我们区域
    st.markdown("#### 📞 联系我们")
    contact_email = "faramita@jusdot.com"
    st.markdown(f"""
    ✉️ 邮箱联系： [{contact_email}](mailto:{contact_email})
    """, unsafe_allow_html=True)

    # 可选：添加反馈或跳转按钮
    if st.button("💬 提交反馈"):
        st.toast("功能开发中，敬请期待！", icon="🛠️")

