import os
import sqlite3


DB_FILE = "./users.db"


def init_database():
    # 确保目录存在
    os.makedirs(os.path.dirname(DB_FILE), exist_ok=True)

    conn = sqlite3.connect(DB_FILE)
    c = conn.cursor()

    # 创建用户表
    c.execute('''
    CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        username TEXT UNIQUE NOT NULL,
        password TEXT NOT NULL
    )
    ''')

    conn.commit()
    conn.close()
    print("[INFO] ✅ 数据库初始化完成!")


if __name__ == "__main__":
    init_database()

